﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="TransactionsWithFilters.aspx.cs"
    Inherits="Localization.TransactionsWithFilters" Culture="auto" meta:resourcekey="PageResource1"
    UICulture="auto" %>

<%@ Register Assembly="Localization.Controls" Namespace="Localization.Controls" TagPrefix="cc1" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Transactions</title>

    <script type="text/javascript">
    // fires when the form submits.
    function updateValuesWithUnFormatted() {
        var fromAmount = $find("FromCurrencyTextBox");
        var toAmount = $find("ToCurrencyTextBox");
        
        // using the unformatted values, reformat them into dates and compare them.
        var unFormattedFrom = fromAmount.get_unFormattedValue();
        var unFormattedTo = toAmount.get_unFormattedValue();

        if (unFormattedFrom !== null) {
            fromAmount.get_element().value = unFormattedFrom;
        }
        if (unFormattedTo !== null) {
            toAmount.get_element().value = unFormattedTo;
        }
        
        return true;
    }
    </script>

</head>
<body>
    <form id="form1" runat="server" onsubmit="return updateValuesWithUnFormatted()">
    <asp:ScriptManager ID="ScriptManager" runat="server" EnableScriptGlobalization="True"
        EnableScriptLocalization="true">
        <Scripts>
            <asp:ScriptReference Path="~/ClientScript/Filter.js" ResourceUICultures="es-mx, fr" />
        </Scripts>
    </asp:ScriptManager>
    <div id="CultureSelector" style="position: absolute; left: 610px;">
        <asp:Label ID="SelectCultureLabel" runat="server" meta:resourcekey="SelectCultureLabelResource" />
        <br />
        <asp:DropDownList ID="CultureSelectorDropDown" runat="server" AutoPostBack="True"
            meta:resourcekey="CultureSelectorDropDownResource1">
            <asp:ListItem Text="English / United States" Value="en-us" meta:resourcekey="ListItemResource1"></asp:ListItem>
            <asp:ListItem Text="Spanish / Mexico" Value="es-mx" meta:resourcekey="ListItemResource2"></asp:ListItem>
            <asp:ListItem Text="French" Value="fr" meta:resourcekey="ListItemResource3"></asp:ListItem>
        </asp:DropDownList>
    </div>
    <div id="FilterPanel" style="position: relative; top: 2px; left: 5px;">
        <div id="CurrencyFilterPanel" style="position: absolute;">
            <div id="CurrencyRangeFilterHeader" style="position: relative">
                <asp:Label ID="CurrencyRangeLabel" runat="server" Text="Amount Filter" meta:resourcekey="CurrencyRangeLabelResource1" />
            </div>
            From:
            <cc1:CurrencyTextBox ID="FromCurrencyTextBox" runat="server" Width="75px" Wrap="False" />
            To:
            <cc1:CurrencyTextBox ID="ToCurrencyTextBox" runat="server" Width="75px" Wrap="False" />
            <asp:Button ID="FilterButton" runat="server" Text="Filter Transactions" OnClientClick="return checkAmounts();"
                meta:resourcekey="FilterButtonResource1" />
        </div>
    </div>
    <div id="TransactionPanel" style="position: absolute; top: 75px; left: 15px;">
        <asp:Label ID="TransactionGridLabel" runat="server" Font-Names="Arial" Font-Bold="true"
            meta:resourcekey="TransactionGridLabelResource" />
        <asp:GridView ID="TransactionsView" runat="server" AutoGenerateColumns="False" CellPadding="4"
            ForeColor="#333333" GridLines="None" Width="748px" DataSourceID="TransactionDataSource"
            meta:resourcekey="TransactionsViewResource1">
            <RowStyle BackColor="#F7F6F3" ForeColor="#333333" />
            <Columns>
                <asp:BoundField HeaderText="Name" DataField="Name" meta:resourcekey="BoundFieldResource1" />
                <asp:BoundField HeaderText="Date" DataField="Date" DataFormatString="{0:d}" HtmlEncode="false"
                    meta:resourcekey="BoundFieldResource2" />
                <asp:BoundField HeaderText="Amount" DataField="Amount" DataFormatString="{0:c}" HtmlEncode="false"
                    meta:resourcekey="BoundFieldResource3" />
                <asp:CheckBoxField DataField="Paid" HeaderText="Paid" ReadOnly="True" meta:resourcekey="CheckBoxFieldResource1" />
            </Columns>
            <HeaderStyle BackColor="#5D7B9D" Font-Bold="True" ForeColor="White" HorizontalAlign="Left" />
            <AlternatingRowStyle BackColor="White" ForeColor="#284775" />
        </asp:GridView>
    </div>
    <asp:ObjectDataSource ID="TransactionDataSource" runat="server" SelectMethod="GetTransactions"
        TypeName="Localization.Transaction"></asp:ObjectDataSource>
    </form>
</body>
</html>
